﻿using System;
using System.Collections.Generic;
using System.Text;
using IndianHealthService.BMXNet.Services;
using IndianHealthService.BMXNet.Model;

namespace IndianHealthService.BMXNet
{
    /// <summary>
    /// The LocalSession is scoped to the client, whether EHR/VueCentric or a WinForm application. 
    /// User management, patient/visit context, and local events are the key services.  Components/controls that are programmed
    /// against this API will work within both the EhrFramework and WinFramework environments.
    /// </summary>
    public interface LocalSession:Log
    {
        /// <summary>
        /// The current patient and visit context.  
        /// </summary>
        /// <example>
        /// The context object is access exclusively through the LocalSession and LocalSession
        /// events.  The context can be obtained if your control or component is a LocalSessionConsumer and if so then
        /// define the Context property as follows:
        /// <code>
        /// public Context Context
        /// {
        ///     get { return this.LocalSession == null ? null : this.LocalSession.Context; }
        /// }
        /// </code>
        /// </example> 
        Context Context { get; }


        /// <summary>
        /// Authenticated user associated with LocalSession
        /// </summary>
        /// <remarks>
        /// If there are also RemoteSessions, the RemoteSessions will have the same User object
        /// </remarks>       
        /// <example>
        /// <code>
        /// this.StatusLabel.Text= aLocalSession.User == null ? "No user" : aLocalSession.User.Name;
        /// </code> 
        /// </example>
        User User { get; }

        /// <summary>
        /// Create a new user object.  
        /// </summary>
        /// <remarks>
        /// Instances of user are used by Frameworks or for configuration/comparisons.
        /// </remarks>
        /// <param name="aName">Display name of the user</param>
        /// <param name="anIen">IEN or DUZ of the User</param>
        /// <param name="aDivision">Currently set division of the user</param>
        /// <returns></returns>
        User NewUser(String aName, String anIen,Division aDivision);
        
        /// <summary>
        /// Access to the LocalSessions EventServices
        /// </summary>
        LocalEventService EventServices { get; }

      
        /// <summary>
        /// Simple uniform call for local notifications to the user when an exception occurs.
        /// </summary>
        /// <remarks>
        /// API is not commonly used
        /// </remarks>
        /// <param name="aTitle">Title of the dialog</param>
        /// <param name="anException">Exception to be displayed</param>
        void Notify(String aTitle, Exception anException);
        /// <summary>
        /// Simple uniform call for local notifications to the user.
        /// </summary>
        /// <remarks>
        /// API is not commonly used.
        /// </remarks>
        /// <param name="aTitle">Title of the dialog</param>
        /// <param name="aMessage">Message to be displayed</param>
        void Notify(String aTitle, String aMessage);
        
        /// <summary>
        /// Call to close the LocalSession which is the last action to take when
        /// shutdown down your application.  
        /// </summary>
        /// <remarks>
        /// In the EHR this call does nothing because each instance of BMX EhrFramework manages
        /// a single component within the greater EHR/VueCentric framework.
        /// In a WinForm application this call shuts down the WinFramework, closes all RemoteSessions,
        /// and closes the LocalSession and disconnects from RPMS.
        /// </remarks>
        void Close();
   }
}
